package nemosofts.voxradio.fragment.Online;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.appcompat.widget.SearchView;
import androidx.core.view.MenuItemCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.ads.consent.ConsentInformation;
import com.google.ads.consent.ConsentStatus;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.ads.mediation.facebook.FacebookMediationAdapter;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.nativead.NativeAd;

import java.util.ArrayList;

import nemosofts.voxradio.R;
import nemosofts.voxradio.activity.PodcastsByActivity;
import nemosofts.voxradio.adapter.AdapterPodcasts;
import nemosofts.voxradio.asyncTask.LoadPodcasts;
import nemosofts.voxradio.callback.Callback;
import nemosofts.voxradio.dialog.VerifyDialog;
import nemosofts.voxradio.fragment.Search.FragmentSearchPodcasts;
import nemosofts.voxradio.interfaces.PodcastsListener;
import nemosofts.voxradio.item.ItemPodcasts;
import nemosofts.voxradio.utils.recycler.EndlessRecyclerViewScrollListener;
import nemosofts.voxradio.utils.helper.Helper;

public class FragmentPodcasts extends Fragment {

    private Helper helper;
    private RecyclerView rv;
    private AdapterPodcasts adapterPodcasts;
    private ArrayList<ItemPodcasts> arrayList;
    private ProgressBar progressBar;
    private FrameLayout frameLayout;
    private String errr_msg, homeSecId ="";
    private GridLayoutManager glm_banner;
    private int page = 1, nativeAdPos = 0;
    private Boolean isOver = false, isScroll = false, isLoading = false, isFromHome = false;

    private AdLoader adLoader;
    private final ArrayList<NativeAd> arrayListNativeAds = new ArrayList<>();

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.fragment_list_normal, container, false);

        helper = new Helper(requireContext(), (position, type) -> {
            if(adapterPodcasts.getItem(position) != null) {
                Intent intent = new Intent(requireContext(), PodcastsByActivity.class);
                intent.putExtra("id",arrayList.get(position).getId());
                intent.putExtra("name", arrayList.get(position).getName());
                requireActivity().startActivity(intent);
            }
        });

        try {
            homeSecId = getArguments().getString("id");
            isFromHome = true;
        } catch (Exception e) {
            homeSecId = "";
            isFromHome = false;
            e.printStackTrace();
        }

        arrayList = new ArrayList<>();

        progressBar = rootView.findViewById(R.id.pb);
        frameLayout = rootView.findViewById(R.id.fl_empty);
        rv = rootView.findViewById(R.id.rv);
        glm_banner = new GridLayoutManager(getActivity(), 2);
        glm_banner.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup() {
            @Override
            public int getSpanSize(int position) {
                return (adapterPodcasts.getItemViewType(position) == -2 || adapterPodcasts.isHeader(position)) ? glm_banner.getSpanCount() : 1;
            }
        });

        rv.setLayoutManager(glm_banner);
        rv.setItemAnimator(new DefaultItemAnimator());
        rv.setHasFixedSize(true);

        if(Boolean.FALSE.equals(isFromHome)) {
            rv.addOnScrollListener(new EndlessRecyclerViewScrollListener(glm_banner) {
                @Override
                public void onLoadMore(int p, int totalItemsCount) {
                    if (getActivity() != null){
                        if (Boolean.FALSE.equals(isOver)) {
                            if (Boolean.FALSE.equals(isLoading)) {
                                isLoading = true;
                                new Handler().postDelayed(() -> {
                                    isScroll = true;
                                    loadAlbums();
                                }, 0);
                            }
                        } else {
                            adapterPodcasts.hideHeader();
                        }
                    }
                }
            });
        }

        if(Boolean.TRUE.equals(Callback.isNativeAd)) {
            if(Callback.nativeAdShow%2 != 0) {
                nativeAdPos = Callback.nativeAdShow + 1;
            } else {
                nativeAdPos = Callback.nativeAdShow;
            }
        }

        loadAlbums();

        setHasOptionsMenu(true);
        return rootView;
    }

    @Override
    public void onCreateOptionsMenu(@NonNull Menu menu, @NonNull MenuInflater inflater) {
        menu.clear();
        inflater.inflate(R.menu.menu_search, menu);
        MenuItem item = menu.findItem(R.id.menu_search);
        MenuItemCompat.setShowAsAction(item, MenuItemCompat.SHOW_AS_ACTION_COLLAPSE_ACTION_VIEW | MenuItemCompat.SHOW_AS_ACTION_IF_ROOM);
        SearchView searchView = (SearchView) menu.findItem(R.id.menu_search).getActionView();
        searchView.setOnQueryTextListener(queryTextListener);
    }

    SearchView.OnQueryTextListener queryTextListener = new SearchView.OnQueryTextListener() {
        @Override
        public boolean onQueryTextSubmit(@NonNull String s) {
            Callback.search_item = s.replace(" ", "%20");
            FragmentSearchPodcasts fsearch = new FragmentSearchPodcasts();
            FragmentManager fm = getFragmentManager();
            FragmentTransaction ft = fm.beginTransaction();
            ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
            ft.hide(getFragmentManager().getFragments().get(getFragmentManager().getBackStackEntryCount()));
            ft.add(R.id.fragment, fsearch, getString(R.string.search_podcasts));
            ft.addToBackStack(getString(R.string.search_podcasts));
            ft.commit();
            return true;
        }

        @Override
        public boolean onQueryTextChange(String s) {
            return false;
        }
    };

    private void loadAlbums() {
        if (helper.isNetworkAvailable()) {
            String helper_name = Boolean.TRUE.equals(isFromHome) ? Callback.METHOD_HOME_DETAILS : Callback.METHOD_PODCASTS;
            LoadPodcasts loadPodcasts = new LoadPodcasts(new PodcastsListener() {
                @Override
                public void onStart() {
                    if (arrayList.isEmpty()) {
                        frameLayout.setVisibility(View.GONE);
                        rv.setVisibility(View.GONE);
                        progressBar.setVisibility(View.VISIBLE);
                    }
                }

                @Override
                public void onEnd(String success, String verifyStatus, String message, ArrayList<ItemPodcasts> arrayListPod) {
                    if (getActivity() != null) {
                        if (success.equals("1")) {
                            if (!verifyStatus.equals("-1")) {
                                if (arrayListPod.isEmpty()) {
                                    isOver = true;
                                    errr_msg = getString(R.string.err_no_data_found);
                                    setEmpty();
                                } else {
                                    for (int i = 0; i < arrayListPod.size(); i++) {
                                        arrayList.add(arrayListPod.get(i));
                                        if (Boolean.TRUE.equals(Callback.isNativeAd)) {
                                            int abc = arrayList.lastIndexOf(null);
                                            if (((arrayList.size() - (abc + 1)) % nativeAdPos == 0)) {
                                                arrayList.add(null);
                                            }
                                        }
                                    }
                                    page = page + 1;
                                    setAdapter();
                                }
                            } else {
                                new VerifyDialog(getActivity(), getString(R.string.err_unauthorized_access), message);
                            }
                        } else {
                            isOver = true;
                            try {
                                adapterPodcasts.hideHeader();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                            errr_msg = getString(R.string.err_server);
                            setEmpty();
                        }
                        progressBar.setVisibility(View.GONE);
                        isLoading = false;
                    }
                }
            }, helper.getAPIRequest(helper_name, page, homeSecId, "", "", "", "", "", "", "","","","","", null));
            loadPodcasts.execute();
        } else {
            errr_msg = getString(R.string.err_internet_not_connected);
            setEmpty();
        }
    }

    @SuppressLint("NotifyDataSetChanged")
    private void setAdapter() {
        if (Boolean.FALSE.equals(isScroll)) {
            adapterPodcasts = new AdapterPodcasts(getActivity(), arrayList, (itemPodcasts, position) -> helper.showInterAd(position, ""));
            rv.setAdapter(adapterPodcasts);
            setEmpty();
            loadNativeAds();
        } else {
            adapterPodcasts.notifyDataSetChanged();
        }
    }

    private void loadNativeAds() {
        if (Boolean.TRUE.equals(Callback.isNativeAd && !Callback.adNetwork.equals(Callback.AD_TYPE_APPLOVIN) && !Callback.adNetwork.equals(Callback.AD_TYPE_STARTAPP)
                && !Callback.adNetwork.equals(Callback.AD_TYPE_IRONSOURCE)) && arrayList.size() >= 10) {

            AdLoader.Builder builder = new AdLoader.Builder(requireActivity(), Callback.nativeAdID);

            Bundle extras = new Bundle();
            if (ConsentInformation.getInstance(getActivity()).getConsentStatus() != ConsentStatus.PERSONALIZED) {
                extras.putString("npa", "1");
            }

            AdRequest adRequest;
            if(Callback.adNetwork.equals(Callback.AD_TYPE_ADMOB)) {
                adRequest = new AdRequest.Builder()
                        .addNetworkExtrasBundle(AdMobAdapter.class, extras)
                        .build();
            } else {
                adRequest = new AdRequest.Builder()
                        .addNetworkExtrasBundle(AdMobAdapter.class, new Bundle())
                        .addNetworkExtrasBundle(FacebookMediationAdapter.class, extras)
                        .build();
            }

            adLoader = builder.forNativeAd(
                    nativeAd -> {
                        try {
                            if(adLoader.isLoading()) {
                                arrayListNativeAds.add(nativeAd);
                            } else {
                                arrayListNativeAds.add(nativeAd);
                                adapterPodcasts.addAds(arrayListNativeAds);
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }).build();
            adLoader.loadAds(adRequest, 5);
        }
    }

    public void setEmpty() {
        if (!arrayList.isEmpty()) {
            rv.setVisibility(View.VISIBLE);
            frameLayout.setVisibility(View.GONE);
            progressBar.setVisibility(View.GONE);
        } else {
            rv.setVisibility(View.GONE);
            frameLayout.setVisibility(View.VISIBLE);
            progressBar.setVisibility(View.INVISIBLE);

            frameLayout.removeAllViews();
            LayoutInflater inflater = (LayoutInflater) requireActivity().getSystemService(Context.LAYOUT_INFLATER_SERVICE);

            @SuppressLint("InflateParams") View myView = inflater.inflate(R.layout.row_empty, null);

            TextView textView = myView.findViewById(R.id.tv_empty_msg);
            textView.setText(errr_msg);

            myView.findViewById(R.id.ll_empty_try).setOnClickListener(v -> loadAlbums());

            frameLayout.addView(myView);
        }
    }
}